' /////////////////////////////////////////////////////////////////////////////
' Atari Joystick virutal NES Gamepad driver
' Simulates NES0 controls with an Atari Joystick on VGA header.
' AUTHOR: Jeff Ledger
' LAST MODIFIED: 4.19.07
' VERSION 1.0
' COMMENTS:
{
 Designed to directly replace 'gamepad_drv_001' where used in Hydra CD demos
 Ajust 'PUB read' code as required for DPAD/AB controls
}

' ///////////////////////////////////////////////////////////////////////////


CON
 {No variables requires}

VAR

  long  cogon, cog
  long  junk       'Left to maintain compatibility
  long  compat     'Left to maintain compatibility 

PUB start : okay

'' Start the NES gamepad reading process
'' returns false if no cog available
''
  stop
  okay := cogon := (cog := cognew(@junk,@compat)) > 0


PUB stop

'' Stops driver - frees a cog

  if cogon~
    cogstop(cog)

PUB read : nes_bits

'Adjust remarked entries below as required.
'This is designed for the adapter: 'atari_vga_schematic.jpg"

  ' NES bit encodings for NES gamepad 0  Provided as reference
' NES0_RIGHT  = %00000000_00000001
' NES0_LEFT   = %00000000_00000010
' NES0_DOWN   = %00000000_00000100
' NES0_UP     = %00000000_00001000
' NES0_START  = %00000000_00010000
' NES0_SELECT = %00000000_00100000
' NES0_B      = %00000000_01000000
' NES0_A      = %00000000_10000000

  ' NES bit encodings for NES gamepad 1  Provided as reference
' NES1_RIGHT  = %00000001_00000000
' NES1_LEFT   = %00000010_00000000
' NES1_DOWN   = %00000100_00000000
' NES1_UP     = %00001000_00000000
' NES1_START  = %00010000_00000000
' NES1_SELECT = %00100000_00000000
' NES1_B      = %01000000_00000000
' NES1_A      = %10000000_00000000

  nes_bits := 0
  
  DirA[16]  := 0 'Set to read FIRE BUTTON
  DirA[17]  := 0 'Set to read RIGHT
  DirA[18]  := 0 'part of VGA DAC, set as In for safety  
  DirA[19]  := 0 'part of VGA DAC, set as In for safety  
  DirA[19]  := 0 'Set to read LEFT
  DirA[20]  := 0 'part of VGA DAC, set as In for safety  
  DirA[21]  := 0 'Set to read DOWN
  DirA[22]  := 0 'part of VGA DAC, set as In for safety
  DirA[23]  := 0 'Set to read UP


   if ina[16] == 1 'Read Fire show as NES0_START
      nes_bits := %00000000_00010000

'  if ina[16] == 1 'Read Fire show as NES0_SELECT
'     nes_bits := %00000000_00100000


  if ina[17] == 1 'Read RIGHT show as NES0_DPAD Right
     nes_bits := %00000000_00000001

  if ina[19] == 1 'Read LEFT  show as NES0_DPAD Left
     nes_bits := %00000000_00000010


'  if ina[21] == 1 'Read DOWN  show as NES0_B button
'     nes_bits := %00000000_01000000

  if ina[21] == 1 'Read Down  show as NES0_DPAD down
     nes_bits := %00000000_00000100


'  if ina[23] == 1 'Read UP    show as NES0_A button
'     nes_bits := %00000000_10000000

  if ina[23] == 1 'Read UP    show as NES0_DPAD up
     nes_bits := %00000000_00001000



PUB button(WhichOne)
{{ Return value:     true or false                                          }}
  if WhichOne == read
    return true
  else
    return false

